/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.views;

import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.js.views.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.model.ClassElement;
import com.aptana.js.core.model.ClassGroupElement;
import com.aptana.js.core.model.EventElement;
import com.aptana.js.core.model.JSElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JSIndexViewContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        List result = Collections.emptyList();
        if (parentElement instanceof JSElement) {
            JSElement root = (JSElement)parentElement;
            List temp = CollectionsUtil.newList((Object[])new ClassGroupElement[]{new ClassGroupElement(Messages.JSIndexViewContentProvider_WorkspaceGroupLabel, JSIndexQueryHelper.getJSCoreIndex()), new ClassGroupElement(Messages.JSIndexViewContentProvider_ProjectGroupLabel, root.getIndex())});
            IProject project = root.getProject();
            if (project != null) {
                Set entries = this.getBuildPathManager().getBuildPaths(project);
                for (IBuildPathEntry entry : entries) {
                    Index index = this.getIndexManager().getIndex(entry.getPath());
                    temp.add(new ClassGroupElement(index.getRoot().toASCIIString(), index));
                }
            }
            result = temp;
        } else if (parentElement instanceof ClassGroupElement) {
            ClassGroupElement group = (ClassGroupElement)parentElement;
            result = group.getClasses();
        } else if (parentElement instanceof ClassElement) {
            ClassElement type = (ClassElement)parentElement;
            ArrayList temp = new ArrayList();
            temp.addAll(type.getProperties());
            temp.addAll(type.getEvents());
            result = temp;
        } else if (parentElement instanceof EventElement) {
            EventElement event = (EventElement)parentElement;
            result = event.getProperties();
        }
        return result.toArray(new Object[result.size()]);
    }

    protected BuildPathManager getBuildPathManager() {
        return BuildPathManager.getInstance();
    }

    public Object[] getElements(Object inputElement) {
        Object[] result;
        if (inputElement instanceof IProject) {
            IProject project = (IProject)inputElement;
            result = new Object[]{new JSElement(project)};
        } else {
            result = new Object[]{};
        }
        return result;
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ClassGroupElement) {
            ClassGroupElement classGroup = (ClassGroupElement)element;
            return classGroup.hasChildren();
        }
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

